//
//  LogGuideView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/13.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "LogGuideView.h"
#import "UIColor+Hex.h"
#import "Constants.h"

@interface LogGuideView ()

@property (nonatomic, strong)UIView *backgroundView;
@property (nonatomic, strong)UIImageView *img_message;




@end

@implementation LogGuideView
#pragma mark - life cycle
- (instancetype)init
{
    self = [super init];
    if (self) {
        [self initUI];
    }
    
    return self;
}

- (void)initUI
{
    self.frame =ScreenBounds;
    [self addSubview:self.backgroundView];
   
    
}

#pragma mark - public methods
+(void)showGuideView
{
    
     
    BOOL show = [[NSUserDefaults standardUserDefaults]boolForKey:@"LogVCGuide"];
    if (show) {
        return;
    }
    
    LogGuideView *showView = [[LogGuideView alloc]init];
    [showView showWithAnimation:YES];
}

#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
    
    
}

- (void)dismissWithAnimation:(BOOL)animation
{
    
    
    
    
  
    [self.backgroundView removeFromSuperview];
    [self.img_message removeFromSuperview];
  
    [self removeFromSuperview];
    
    
    
    self.backgroundView = nil;
    self.img_message = nil;
   
    
}

#pragma mark - event response
-(void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    
    [[NSUserDefaults standardUserDefaults]setBool:YES forKey:@"LogVCGuide"];
    [[NSUserDefaults standardUserDefaults]synchronize];
    [self dismissWithAnimation:YES];
}

#pragma mark - private methods
-(void)rangleView:(CGRect)frame{    UIBezierPath *rectPath = [UIBezierPath bezierPathWithRect:self.frame];    UIBezierPath *circlePath = [UIBezierPath bezierPathWithOvalInRect:frame];    [rectPath appendPath:circlePath];    CAShapeLayer *mask1 = [CAShapeLayer layer];    mask1.frame = CGRectMake(0, 0, ScreenWidth, ScreenHeight);    mask1.backgroundColor = [UIColor clearColor].CGColor;    mask1.fillColor = [UIColor whiteColor].CGColor;    mask1.path = rectPath.CGPath;    mask1.fillRule = kCAFillRuleEvenOdd;    self.layer.mask = mask1;}



#pragma mark - getters and setters
- (UIView *)backgroundView
{
    if (!_backgroundView) {
        _backgroundView = [[UIView alloc]initWithFrame:ScreenBounds];
        _backgroundView.backgroundColor = [UIColor colorWithHex:0x323232 alpha:0.8];;
        _backgroundView.alpha = 0.6f ;
        _backgroundView.userInteractionEnabled = YES;
        
//        UIBezierPath *path = [UIBezierPath bezierPathWithOvalInRect:CGRectMake(20 * WIDTHRADIU, cl_kNavigationBarHeight + 95 * WIDTHRADIU, 168 * WIDTHRADIU, 95 * WIDTHRADIU)];
//        // 绘制透明区域
//        CAShapeLayer *shapeLayer = [CAShapeLayer layer];
//        shapeLayer.path = path.CGPath;
//        [_backgroundView.layer setMask:shapeLayer];
        
        [self rangleView:CGRectMake(20 * WIDTHRADIU, cl_kNavigationBarHeight + 95 * WIDTHRADIU, 168 * WIDTHRADIU, 95 * WIDTHRADIU)];

        [_backgroundView addSubview:self.img_message];
        
        [self.img_message mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.offset(cl_kNavigationBarHeight + 190 * WIDTHRADIU);
            make.left.offset(80 * WIDTHRADIU);
        }];
        
        UITapGestureRecognizer *myTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(didTapBackgroundView:)];
        [_backgroundView addGestureRecognizer:myTap];
    }
    return _backgroundView;
}

- (UIImageView *)img_message
{
    if (!_img_message) {
        _img_message = [[UIImageView alloc]init];
        _img_message.image = [UIImage imageNamed:@"my_gold_Preliminaryprompt_Getcoins_normal"];
    }
    return _img_message;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
