//
//  WithDrawView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/8.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "WithDrawView.h"
#import "Constants.h"
#import "UIColor+Hex.h"

@interface WithDrawView ()

@property (nonatomic, strong)UIView *backView;
@property (nonatomic, strong)UILabel *lb_myWallet;
@property (nonatomic, strong)UILabel *lb_moneyNumber;

@end
@implementation WithDrawView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
         self.backgroundColor = RGBCOLOR(244, 244, 244);
        [self addSubview:self.backView];
        [self addSubview:self.lb_myWallet];
        [self addSubview:self.lb_moneyNumber];
        [self setupUI];
    }
    return self;
}
- (void)setupUI
{
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.height.offset(84 * WIDTHRADIU);
    }];
    
    [self.lb_myWallet mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
    [self.lb_moneyNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_myWallet.mas_bottom).offset(10 * WIDTHRADIU);
        make.left.equalTo(self.lb_myWallet);
        make.height.offset(23 * WIDTHRADIU);
    }];
   
    
}

#pragma mark - getters and setters
- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc]init];
        _backView.backgroundColor = [UIColor colorWithHex:0xed8b0b];
    }
    return _backView;
}
- (UILabel *)lb_myWallet
{
    if (!_lb_myWallet) {
        _lb_myWallet = [[UILabel alloc]init];
        _lb_myWallet.text = @"我的钱包(元)";
        _lb_myWallet.textColor = [UIColor whiteColor];
        _lb_myWallet.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
    }
    return _lb_myWallet;
}
- (UILabel *)lb_moneyNumber
{
    if (!_lb_moneyNumber) {
        _lb_moneyNumber = [[UILabel alloc]init];
        _lb_moneyNumber.text = @"1.50元";
        _lb_moneyNumber.textColor = [UIColor whiteColor];
        _lb_moneyNumber.font = [UIFont systemFontOfSize:30 * WIDTHRADIU];
    }
    return _lb_moneyNumber;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
