//
//  WithDrawFooterView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/8.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "WithDrawFooterView.h"
#import "UIColor+Hex.h"
#import "Constants.h"

@interface WithDrawFooterView ()

@property (nonatomic, strong)UIView *backView;

@property (nonatomic, strong)UIImageView *img_wx;

@property (nonatomic, strong)UILabel *lb_state;

@property (nonatomic, strong)UIButton *btn_bind;

@property (nonatomic, strong)UIImageView *img_arrow;

@end
@implementation WithDrawFooterView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = RGBCOLOR(244, 244, 244);
        [self addSubview:self.backView];
        [self addSubview:self.img_wx];
        [self addSubview:self.lb_state];
        [self addSubview:self.btn_bind];
        [self addSubview:self.img_arrow];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.height.offset(35 * WIDTHRADIU);
    }];
    [self.img_wx mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(0);
        make.left.offset(20 * WIDTHRADIU);
    }];
    [self.lb_state mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.img_wx);
        make.left.equalTo(self.img_wx.mas_right).offset(10 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
    [self.img_arrow mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lb_state);
        make.right.offset(-20 * WIDTHRADIU);
    }];
    [self.btn_bind mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.img_arrow);
        make.right.equalTo(self.img_arrow.mas_left).offset(- 5 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
}
#pragma mark - getters and setters
- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc]init];
        _backView.backgroundColor = [UIColor whiteColor];
    }
    return _backView;
}

- (UIImageView *)img_wx
{
    if (!_img_wx) {
        _img_wx = [[UIImageView alloc]init];
        _img_wx.image = [UIImage imageNamed:@"my_wallet_Withdrawaloffunds_Notloggedin_WeChat_default"];
    }
    return _img_wx;
}

- (UILabel *)lb_state
{
    if (!_lb_state) {
        _lb_state = [[UILabel alloc]init];
        _lb_state.text = @"您尚未绑定微信";
        _lb_state.textColor = [UIColor colorWithHex:0x999999];
        _lb_state.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
    }
    return _lb_state;
}

- (UIButton *)btn_bind
{
    if (!_btn_bind) {
        _btn_bind = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_bind setTitle:@"立即绑定" forState:UIControlStateNormal];
        [_btn_bind setTitleColor:[UIColor colorWithHex:0x4d4d4d] forState:UIControlStateNormal];
        _btn_bind.titleLabel.font = [UIFont systemFontOfSize:14 * WIDTHRADIU];
    }
    return _btn_bind;
}

- (UIImageView *)img_arrow
{
    if (!_img_arrow) {
        _img_arrow = [[UIImageView alloc]init];
        _img_arrow.image = [UIImage imageNamed:@"my_wallet_Withdrawaloffunds_Binding_arrow_default"];
    }
    return _img_arrow;
}
@end
