//
//  CoinsFooterView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsFooterView.h"
#import "UIColor+Hex.h"
#import "Constants.h"


@interface CoinsFooterView ()





@end
@implementation CoinsFooterView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = RGBCOLOR(244, 244, 244);
        [self addSubview:self.lb_title];
        [self addSubview:self.lb_content];
        [self setupUI];
    }
    return self;
}
- (void)setupUI
{
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
    [self.lb_content mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_title.mas_bottom).offset(10 * WIDTHRADIU);
        make.left.offset(20 * WIDTHRADIU);
    }];
}
#pragma getters and setters
- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.textColor = [UIColor colorWithHex:0x808080];
        _lb_title.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _lb_title.text = @"金币兑换";
    }
    return _lb_title;
}
- (UILabel *)lb_content
{
    if (!_lb_content) {
        _lb_content = [[UILabel alloc]init];
        NSString *text1 = @"1、金币兑换汇率受每日新闻总收益影响，会出现汇率浮动。\n";
        NSString *text2 = @"2、兑换的金额在“我的”-“我的钱包”中显示。\n";
        NSString *text3 = @"3、“我的钱包”中可提现。\n";
        
         NSMutableParagraphStyle * paragraphStyle = [[NSMutableParagraphStyle alloc] init];
         [paragraphStyle setLineSpacing:8];
        
        NSMutableAttributedString *attributedString1 = [[NSMutableAttributedString alloc] initWithString:text1 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
         NSMutableAttributedString *attributedString2 = [[NSMutableAttributedString alloc] initWithString:text2 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
        NSMutableAttributedString *attributedString3 = [[NSMutableAttributedString alloc] initWithString:text3 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
        [attributedString1 appendAttributedString:attributedString2];
        [attributedString1 appendAttributedString:attributedString3];
        
         NSRange range = [[[text1 stringByAppendingString:text2] stringByAppendingString:text3] rangeOfString:[[text1 stringByAppendingString:text2] stringByAppendingString:text3]];
        [attributedString1 addAttributes:@{NSForegroundColorAttributeName:[UIColor colorWithHex:0x999999],
                                NSFontAttributeName:[UIFont systemFontOfSize:12 * WIDTHRADIU]} range:range];
        _lb_content.attributedText = attributedString1;
        _lb_content.numberOfLines = 0;
    }
    return _lb_content;
}


@end
