//
//  CoinsExchangeCell.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsExchangeCell.h"
#import "UIColor+Hex.h"
#import "Constants.h"
#import <Masonry.h>

@interface CoinsExchangeCell ()



@end
@implementation CoinsExchangeCell
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self addSubview:self.imageView];
        [self addSubview:self.lb_money];
        [self addSubview:self.lb_coins];
        [self slayoutMyUI];
        
        self.layer.borderWidth = 1;
        self.layer.borderColor = [UIColor colorWithHex:0xcccccc].CGColor;
        self.layer.cornerRadius = 5;
        self.backgroundColor = [UIColor whiteColor];
    }
    return self;
}


- (void)slayoutMyUI
{
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.offset(0);
    }];
    
    [self.lb_money mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(10 * WIDTHRADIU);
        make.centerX.equalTo(self);
    }];
    [self.lb_coins mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_money);
        make.top.equalTo(self.lb_money.mas_bottom).offset(1 * WIDTHRADIU);
    }];
    self.selected = NO;
}

#pragma mark - event response



#pragma mark - setters and getters
- (UIImageView *)imageView
{
    if (!_imageView) {
        _imageView = [[UIImageView alloc]init];
        _imageView.image = [UIImage imageNamed:@"my_wallet_Withdrawaloffunds_Selected"];
    }
    return _imageView;
}

- (UILabel *)lb_money
{
    if (!_lb_money) {
        _lb_money = [[UILabel alloc]init];
        _lb_money.text = @"1元";
        _lb_money.textAlignment = NSTextAlignmentCenter;
        _lb_money.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_money.font = [UIFont systemFontOfSize:17* WIDTHRADIU];
    }
    return _lb_money;
}

- (UILabel *)lb_coins
{
    if (!_lb_coins) {
        _lb_coins = [[UILabel alloc]init];
        _lb_coins.text = @"10,000金币";
        _lb_coins.textAlignment = NSTextAlignmentCenter;
        _lb_coins.textColor = [UIColor colorWithHex:0x999999];
        _lb_coins.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_coins;
}

- (void)setSelected:(BOOL)selected
{
    _isSelected = selected;
    if (selected) {
        self.imageView.hidden = NO;
        self.layer.borderColor = [UIColor colorWithHex:0xed8b0b].CGColor;
    }else{
        self.imageView.hidden = YES;
        self.layer.borderColor = [UIColor colorWithHex:0xcccccc].CGColor;
    }
}
@end
