//
//  CoinsListItemTableViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsListItemTableViewCell.h"
#import "UIColor+Hex.h"
#import "Constants.h"
#import <Masonry.h>

#import "CoinDetailModel.h"

@interface CoinsListItemTableViewCell ()

@property (nonatomic, strong)UILabel *lb_itemType;

@property (nonatomic, strong)UILabel *lb_timeStamp;

@property (nonatomic, strong)UILabel *lb_addOrReduce;

@property (nonatomic, strong)UIView *lineView;

@end
@implementation CoinsListItemTableViewCell
#pragma mark - life cycle
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self addSubview:self.lb_itemType];
        [self addSubview:self.lb_timeStamp];
        [self addSubview:self.lb_addOrReduce];
        [self addSubview:self.lineView];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.lb_itemType mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        make.left.offset(10 * WIDTHRADIU);
        make.height.offset(16 * WIDTHRADIU);
    }];
    [self.lb_timeStamp mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_itemType.mas_bottom).offset(5 * WIDTHRADIU);
        make.left.equalTo(self.lb_itemType);
        make.height.offset(12 * WIDTHRADIU);
    }];
    [self.lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.offset(10 * WIDTHRADIU);
        make.bottom.offset(0);
        make.height.offset(0.5);
    }];
    [self.lb_addOrReduce mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.right.offset(-10 * WIDTHRADIU);
    }];
}

#pragma mark - public methods
- (void)refreshUIWithData:(id)model
{
    if ([model isKindOfClass:[CoinDetailModel class]]) {
        
        CoinDetailModel *myModel = (CoinDetailModel *)model;
        self.lb_itemType.text = myModel.sourcestr;
        self.lb_timeStamp.text = myModel.create_time;
        self.lb_addOrReduce.text = [NSString stringWithFormat:@"+%@",myModel.socre];
    }
}

#pragma mark - getters and setters
- (UILabel *)lb_itemType
{
    if (!_lb_itemType) {
        _lb_itemType = [[UILabel alloc]init];
        _lb_itemType.text = @"阅读收益";
        _lb_itemType.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_itemType.font = [UIFont systemFontOfSize:16 * WIDTHRADIU];
    }
    return _lb_itemType;
}

- (UILabel *)lb_timeStamp
{
    if (!_lb_timeStamp) {
        _lb_timeStamp = [[UILabel alloc]init];
        _lb_timeStamp.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
        _lb_timeStamp.textColor = [UIColor colorWithHex:0x808080];
        _lb_timeStamp.text = @"2019.06.03";
    }
    return _lb_timeStamp;
}

- (UILabel *)lb_addOrReduce
{
    if (!_lb_addOrReduce) {
        _lb_addOrReduce = [[UILabel alloc]init];
        _lb_addOrReduce.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _lb_addOrReduce.textColor = [UIColor colorWithHex:0xed8b0b];
        _lb_addOrReduce.text = @"+200";
    }
    return _lb_addOrReduce;
}

- (UIView *)lineView
{
    if (!_lineView) {
        _lineView = [[UIView alloc]init];
        _lineView.backgroundColor = [UIColor colorWithHex:0xcccccc];
    }
    return _lineView;
}

- (void)setType:(ListVCType)type
{
    _type = type;
    if (type == ListVCTypeMyWallet) {
        _lb_itemType.text = @"金币兑换现金";
        _lb_addOrReduce.text = @"+2.00";
    }
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
