//
//  SignInSuccessView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/6.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SignInSuccessView.h"
#import "UIColor+Hex.h"
#import "Constants.h"

@interface SignInSuccessView ()
//背景蒙层视图
@property (nonatomic, strong)UIView *backgroundView;

@property (nonatomic, strong)UIView *whiteView;

@property (nonatomic, strong)UIImageView *img_Success;

@property (nonatomic, strong)UILabel *lb_successTitle;

@property (nonatomic, strong)UILabel *lb_num;

@property (nonatomic, strong)UILabel *lb_message;

@end
@implementation SignInSuccessView
#pragma mark - life cycle
- (instancetype)initWithTitle:(NSString *)title
{
    self = [super init];
    if (self) {
        [self initUI];
    }
    return self;
}

- (void)initUI
{
    self.frame =ScreenBounds;
    [self addSubview:self.backgroundView];
    [self addSubview:self.whiteView];
    [self addSubview:self.img_Success];
    [self addSubview:self.lb_successTitle];
    [self addSubview:self.lb_num];

    
    [self setupUI];
}

- (void)setupUI
{
    [self.whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.centerY.equalTo(self).offset(- 15 * WIDTHRADIU);
        make.width.offset(220 * WIDTHRADIU);
        make.height.offset(147 * WIDTHRADIU);
    }];
    
    [self.img_Success mas_makeConstraints:^(MASConstraintMaker *make) {
         make.centerY.equalTo(self).offset(- 85 * WIDTHRADIU);
        make.centerX.equalTo(self).offset(- 6 * WIDTHRADIU);
        make.width.offset(230 * WIDTHRADIU);
        make.height.offset(205 * WIDTHRADIU);
    }];
    
    [self.lb_successTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.height.offset(19 * WIDTHRADIU);
        make.top.equalTo(self.img_Success.mas_bottom).offset(-77 *WIDTHRADIU);
    }];
    
    [self.lb_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.whiteView);
        make.bottom.offset(-14 * WIDTHRADIU);
        make.height.offset(14 * WIDTHRADIU);
    }];
    
    [self.lb_num mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.whiteView);
        make.bottom.equalTo(self.lb_message.mas_top).offset(-20 * WIDTHRADIU);
        make.height.offset(29 * WIDTHRADIU);
    }];
}

#pragma mark - public methods
+ (void)showSuccessViewWithTitle:(NSString *)title
{
    SignInSuccessView *view = [[SignInSuccessView alloc]initWithTitle:title];
    
    [view showWithAnimation:YES];
}


#pragma mark - event response
-(void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    [self dismissWithAnimation:YES];
}


#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
    
    [self addAnimation];
    
}

-(void)addAnimation
{
    self.whiteView.alpha=0;
    self.img_Success.alpha = 0;
    
    self.whiteView.transform=CGAffineTransformMakeScale(0.02, 0.02);
    self.img_Success.transform=CGAffineTransformMakeScale(0.02, 0.02);
    
    [UIView animateWithDuration:0.4f animations:^{
        self.whiteView.transform=CGAffineTransformMakeScale(1.0, 1.0);
        self.whiteView.alpha=1;
        self.img_Success.transform=CGAffineTransformMakeScale(1.0, 1.0);
        self.img_Success.alpha=1;
        
        //pBookSortView.frame=sortFrame;
    }];
    
    
}

- (void)dismissWithAnimation:(BOOL)animation
{
   
    [self.lb_message removeFromSuperview];
    [self.lb_num removeFromSuperview];
    [self.img_Success removeFromSuperview];
    [self.whiteView removeFromSuperview];
    [self.backgroundView removeFromSuperview];
    [self.lb_successTitle removeFromSuperview];
    [self removeFromSuperview];
    
    
    
    self.backgroundView = nil;
    self.whiteView = nil;
    self.img_Success = nil;
    self.lb_num = nil;
    self.lb_message = nil;
    self.lb_successTitle = nil;
    
}
#pragma mark - getters and setters

- (UILabel *)lb_successTitle
{
    if (!_lb_successTitle) {
        _lb_successTitle = [[UILabel alloc]init];
        _lb_successTitle.text = @"签到成功";
        _lb_successTitle.textColor = [UIColor colorWithHex:0xfff597];
        _lb_successTitle.font = [UIFont systemFontOfSize:19 * WIDTHRADIU];
    }
    return _lb_successTitle;
}

- (UIImageView *)img_Success
{
    if (!_img_Success) {
        _img_Success = [[UIImageView alloc]init];
        _img_Success.image = [UIImage imageNamed:@"签到成功"];
    }
    return _img_Success;
}
- (UIView *)whiteView
{
    if (!_whiteView) {
        _whiteView = [[UIView alloc]init];
        _whiteView.backgroundColor = [UIColor whiteColor];
        _whiteView.layer.cornerRadius = 15 * WIDTHRADIU;
        _whiteView.layer.masksToBounds = YES;
        
        [_whiteView addSubview:self.lb_message];
    }
    return _whiteView;
}

- (UILabel *)lb_message
{
    if (!_lb_message) {
        _lb_message = [[UILabel alloc]init];
        _lb_message.text = @"偷偷告诉你，满签奖励多多";
        _lb_message.textColor = [UIColor colorWithHex:0x808080];
        _lb_message.font = [UIFont systemFontOfSize:14 *WIDTHRADIU];
    }
    return _lb_message;
}

- (UILabel *)lb_num
{
    if (!_lb_num) {
        _lb_num = [[UILabel alloc]init];
        _lb_num.text = @"+30";
        _lb_num.textColor = [UIColor colorWithHex:0xfa9502];
        _lb_num.font = [UIFont systemFontOfSize:29 *WIDTHRADIU];
    }
    return _lb_num;
}
- (UIView *)backgroundView
{
    if (!_backgroundView) {
        _backgroundView = [[UIView alloc]initWithFrame:ScreenBounds];
        _backgroundView.backgroundColor = [UIColor blackColor] ;
        _backgroundView.alpha = 0.3f ;
        _backgroundView.userInteractionEnabled = YES;
        UITapGestureRecognizer *myTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(didTapBackgroundView:)];
        [_backgroundView addGestureRecognizer:myTap];
    }
    return _backgroundView;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
