//
//  RetroactiveView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "RetroactiveView.h"

#import "EnsurePaybackFrontView.h"

#import "UIColor+Hex.h"
#import "Constants.h"

@interface RetroactiveView ()

//背景蒙层视图
@property (nonatomic, strong)UIView *backgroundView;

@property (nonatomic, strong)UIView *whiteView;
@property (nonatomic, strong)UILabel *lb_title;
@property (nonatomic, strong)UILabel *lb_message;

@property (nonatomic, strong)EnsurePaybackFrontView *cardView;

@property (nonatomic, strong)UIButton *btn_Retroactive;

@end
@implementation RetroactiveView
#pragma mark - life cycle
- (instancetype)init
{
    self = [super init];
    if (self) {
        
        [self initUI];
        
       
    }
    return self;
}

- (void)initUI
{
    self.frame =ScreenBounds;
    [self addSubview:self.backgroundView];
    [self addSubview:self.whiteView];
    [self setupUI];
}

- (void)setupUI
{
    [self.whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.centerY.equalTo(self).offset(- 80 * WIDTHRADIU);
        make.width.offset(230 * WIDTHRADIU);
        make.height.offset(208 * WIDTHRADIU);
    }];
    
    [self.lb_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(15 * WIDTHRADIU);
        make.centerX.equalTo(self.whiteView);
        make.height.offset(17 * WIDTHRADIU);
    }];
    
    [self.lb_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_title.mas_bottom).offset(10 * WIDTHRADIU);
        make.centerX.equalTo(self);
        make.height.offset(12 * WIDTHRADIU);
    }];
    
    [self.cardView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_message.mas_bottom).offset(15 * WIDTHRADIU);
        make.left.offset(18 * WIDTHRADIU);
        make.right.offset(-18 * WIDTHRADIU);
        make.height.offset(80 * WIDTHRADIU);
    }];
    
    [self.btn_Retroactive mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.cardView.mas_bottom).offset(15 * WIDTHRADIU);
        make.left.offset(15 * WIDTHRADIU);
        make.right.offset(-15 * WIDTHRADIU);
        make.height.offset(35 * WIDTHRADIU);
    }];
    
    
    
}

#pragma mark - public methods
+ (void)showSuccessView
{
    RetroactiveView *view = [[RetroactiveView alloc]init];
    
    
   
    
    [view showWithAnimation:YES];
}

#pragma mark - 弹出视图方法
- (void)showWithAnimation:(BOOL)animation
{
    
    //1.获取当前应用的主窗口
    UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
    [keyWindow addSubview: self];
    
    
    
    [self addAnimation];
    
}

-(void)addAnimation
{
    self.whiteView.alpha=0;
   
    
    self.whiteView.transform=CGAffineTransformMakeScale(0.02, 0.02);
    
    [UIView animateWithDuration:0.4f animations:^{
        self.whiteView.transform=CGAffineTransformMakeScale(1.0, 1.0);
        self.whiteView.alpha=1;
    }];
    
    
}

- (void)dismissWithAnimation:(BOOL)animation
{
    
    [self.lb_title removeFromSuperview];
    [self.lb_message removeFromSuperview];
    
    [self.cardView removeFromSuperview];
    [self.btn_Retroactive removeFromSuperview];
    [self.whiteView removeFromSuperview];
    [self.backgroundView removeFromSuperview];
    [self removeFromSuperview];
    
    
    
    self.backgroundView = nil;
    self.whiteView = nil;
    self.lb_title = nil;
    self.lb_message = nil;
    self.cardView = nil;
    self.btn_Retroactive = nil;
    
}

#pragma mark - event response
-(void)didTapBackgroundView:(UITapGestureRecognizer *)sender
{
    [self dismissWithAnimation:YES];
}

- (void)btnClick:(UIButton *)btn
{
     [self dismissWithAnimation:YES];
}

#pragma mark - private methods

/**
 * @param   lineView    需要绘制成虚线的view
 * @param   lineLength  虚线的宽度
 * @param   lineSpacing  虚线的间距
 * @param   lineColor   虚线的颜色
 */
- (void)drawDashLine:(UIView *)lineView lineLength:(int)lineLength lineSpacing:(int)lineSpacing lineColor:(UIColor *)lineColor
{
    CAShapeLayer *shapeLayer = [CAShapeLayer layer];
    [shapeLayer setBounds:lineView.bounds];
    [shapeLayer setPosition:CGPointMake(CGRectGetWidth(lineView.frame) / 2, CGRectGetHeight(lineView.frame))];
    [shapeLayer setFillColor:[UIColor clearColor].CGColor];
    //  设置虚线颜色为blackColor
    [shapeLayer setStrokeColor:lineColor.CGColor];
    //  设置虚线宽度
    [shapeLayer setLineWidth:CGRectGetHeight(lineView.frame)];
    [shapeLayer setLineJoin:kCALineJoinRound];
    //  设置线宽，线间距
    [shapeLayer setLineDashPattern:[NSArray arrayWithObjects:[NSNumber numberWithInt:lineLength], [NSNumber numberWithInt:lineSpacing], nil]];
    
    //  设置路径
    CGMutablePathRef path = CGPathCreateMutable();
    CGPathMoveToPoint(path, NULL, 0, 0);
    CGPathAddLineToPoint(path, NULL,CGRectGetWidth(lineView.frame), 0);
    [shapeLayer setPath:path];
    CGPathRelease(path);
    //  把绘制好的虚线添加上来
    [lineView.layer addSublayer:shapeLayer];
}

#pragma mark - getters and setters
- (UIView *)whiteView
{
    if (!_whiteView) {
        _whiteView = [[UIView alloc]init];
        _whiteView.backgroundColor = [UIColor whiteColor];
        [_whiteView addSubview:self.lb_title];
        [_whiteView addSubview:self.lb_message];
        [_whiteView addSubview:self.cardView];
        [_whiteView addSubview:self.btn_Retroactive];
        _whiteView.layer.cornerRadius = 15 * WIDTHRADIU;
        _whiteView.layer.masksToBounds = YES;
    }
    return _whiteView;
}

- (UILabel *)lb_title
{
    if (!_lb_title) {
        _lb_title = [[UILabel alloc]init];
        _lb_title.text = @"购买补签卡";
        _lb_title.textColor = [UIColor colorWithHex:0xfa9504];
        _lb_title.font = [UIFont boldSystemFontOfSize:17 * WIDTHRADIU];
    }
    return _lb_title;
}

- (UILabel *)lb_message
{
    if (!_lb_message) {
        _lb_message = [[UILabel alloc]init];
        _lb_message.text = @"当前领取金币数 x 1.5 = 需消耗金币";
         _lb_message.textColor = [UIColor colorWithHex:0x808080];
        _lb_message.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_message;
}

- (EnsurePaybackFrontView *)cardView
{
    if (!_cardView) {
        _cardView = [[EnsurePaybackFrontView alloc]init];
      
    }
    return _cardView;
}



- (UIButton *)btn_Retroactive
{
    if (!_btn_Retroactive) {
        _btn_Retroactive = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_Retroactive.backgroundColor = [UIColor colorWithHex:0xfa9504];
        [_btn_Retroactive setTitle:@"消耗90金币进行补签" forState:UIControlStateNormal];
        [_btn_Retroactive setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _btn_Retroactive.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _btn_Retroactive.layer.cornerRadius = 18 * WIDTHRADIU;
        
        [_btn_Retroactive addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_Retroactive;
}

- (UIView *)backgroundView
{
    if (!_backgroundView) {
        _backgroundView = [[UIView alloc]initWithFrame:ScreenBounds];
        _backgroundView.backgroundColor = [UIColor blackColor] ;
        _backgroundView.alpha = 0.3f ;
        _backgroundView.userInteractionEnabled = YES;
        UITapGestureRecognizer *myTap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(didTapBackgroundView:)];
        [_backgroundView addGestureRecognizer:myTap];
    }
    return _backgroundView;
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
