//
//  CoinsCenterViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/8/6.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsCenterViewController.h"
#import "UIColor+Hex.h"
#import "Constants.h"
#import "ExchangeMoneyBtn.h"

#import "SignInSuccessView.h"
#import "RetroactiveView.h"
#import "RedPackageSuccessView.h"

#import "SignInCollectionViewCell.h"
#import "LineCollectionReusableView.h"

#import "CoinCenterTableViewCell.h"

@interface CoinsCenterViewController ()<UITableViewDelegate,UITableViewDataSource,UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic, strong)UIView *headerView;

@property (nonatomic, strong)UIView *cardView;

//card view
@property (nonatomic, strong)UILabel *lb_coinsNum;

@property (nonatomic, strong)UILabel *lb_coinsNumTitle;

@property (nonatomic, strong)ExchangeMoneyBtn *btn_exchangeMoney;

@property (nonatomic, strong) UILabel *lb_allCoinsNumber;
@property (nonatomic, strong) UILabel *lb_mycoin;
@property (nonatomic, strong) UIView *divideLine;

@property (nonatomic, strong) UILabel *lb_todayCoinsNumber;
@property (nonatomic, strong) UILabel *lb_todayCoin;


@property (nonatomic, strong)UICollectionView *collectionView;

@property (nonatomic, strong)UIButton *btn_signIn;

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong)NSMutableArray *dateArray;

@property (nonatomic, strong)NSMutableArray *dataArray;


@end

@implementation CoinsCenterViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self.view addSubview:self.tableView];
}
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    
    [self.transitionCoordinator animateAlongsideTransition:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
        self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
    }];
}

- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self.lb_coinsNum mas_makeConstraints:^(MASConstraintMaker *make) {
        
        make.top.offset(25 * WIDTHRADIU);
        make.centerX.equalTo(self.cardView);
        make.height.offset(25 * WIDTHRADIU);
    }];
    [self.lb_coinsNumTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_coinsNum.mas_bottom).offset(10 * WIDTHRADIU);
        make.centerX.equalTo(self.cardView);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    [self.btn_exchangeMoney mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(38 * WIDTHRADIU);
        make.right.offset(0);
        make.width.offset(80 * WIDTHRADIU);
        make.height.offset(30 * WIDTHRADIU);
    }];
    
    [self.lb_allCoinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.cardView.mas_centerX).multipliedBy(0.5);
        make.top.equalTo(self.lb_coinsNumTitle.mas_bottom).offset(20 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
    [self.lb_mycoin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_allCoinsNumber);
        make.top.equalTo(self.lb_allCoinsNumber.mas_bottom).offset(10 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    [self.divideLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.cardView);
        make.centerY.equalTo(self.lb_allCoinsNumber.mas_bottom).offset(4 * WIDTHRADIU);
        make.height.offset(35 * WIDTHRADIU);
        make.width.offset(0.5);
    }];
    [self.lb_todayCoinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.cardView.mas_centerX).multipliedBy(1.5);
        make.centerY.equalTo(self.lb_allCoinsNumber);
        make.height.offset(15 * WIDTHRADIU);
    }];
    [self.lb_todayCoin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_todayCoinsNumber);
        make.centerY.equalTo(self.lb_mycoin);
        make.height.offset(13 * WIDTHRADIU);
    }];
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CoinCenterTableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    cell.selectionStyle =  UITableViewCellSelectionStyleNone;
    
    [cell refreshUIWithString:self.dataArray[indexPath.row]];
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 67 * WIDTHRADIU + 0.5;
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return self.dateArray.count;
}
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 1;
}
//这是正确的方法
-(UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath{
    SignInCollectionViewCell * cell  = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    [cell refreshUIWithData:self.dateArray[indexPath.section]];

    return cell;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(33 * WIDTHRADIU, 49 * WIDTHRADIU);
}
- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout insetForSectionAtIndex:(NSInteger)section{
    
    return UIEdgeInsetsMake(0, 0, 0, 0);
}

/**
 分区内cell之间的最小行间距
 */
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section{
    
    return 0.0;
}
/**
 分区内cell之间的最小列间距
 */
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    
    return 0.0;
}


- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath {
    
    if (indexPath.item != (self.dateArray.count - 1) ) {
        LineCollectionReusableView *lineView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"lineCell" forIndexPath:indexPath];
        lineView.backgroundColor = [UIColor whiteColor];
        return lineView;
    }
   
    return nil;
}
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForFooterInSection:(NSInteger)section {
    if (section == (self.dateArray.count - 1)) {
        return CGSizeZero;
    }
    
    CGFloat width = (ScreenWidth - (self.dateArray.count * 33 * WIDTHRADIU) - 40 * WIDTHRADIU)/(self.dateArray.count - 1);
    return CGSizeMake( width > 0 ? width : 17.5 * WIDTHRADIU , 49 * WIDTHRADIU);
}


- (void)exchangeMoneyClick:(UIButton *)sender{
    //[SignInSuccessView showSuccessViewWithTitle:@"+30"];
    //[RetroactiveView showSuccessView];
    [RedPackageSuccessView showSuccessViewWithType:RedPackageTypeNoMultiple];
}

#pragma mark - getters and setters

- (NSMutableArray *)dateArray
{
    
    if (!_dateArray) {
        NSArray *array = @[@{
                               @"type":@"num",
                               @"title":@"周一",
                               @"num":@"30"
                               },
                           @{
                               @"type":@"num",
                               @"title":@"周二",
                               @"num":@"40"
                               },
                           @{
                               @"type":@"redPacket",
                               @"title":@"周三",
                               @"num":@"50"
                               },
                           @{
                               @"type":@"num",
                               @"title":@"周四",
                               @"num":@"60"
                               },
                           @{
                               @"type":@"giftBag",
                               @"title":@"周五",
                               @"num":@"80"
                               },
                           @{
                               @"type":@"num",
                               @"title":@"周六",
                               @"num":@"80"
                               },
                           @{
                               @"type":@"treasureBox",
                               @"title":@"周日",
                               @"num":@"200"
                               },
                           ];
        
        _dateArray = [[NSMutableArray alloc]initWithArray:array];
    }
    return _dateArray;
   
}

- (NSMutableArray *)dataArray
{
    if (!_dataArray ) {
        _dataArray = [NSMutableArray arrayWithObjects:@"gz",@"ts",@"xw",@"tv", nil];
    }
    return _dataArray;
}
- (UIView *)headerView
{
    if (!_headerView) {
        _headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 288 * WIDTHRADIU)];
        _headerView.backgroundColor = [UIColor whiteColor];
        
        [_headerView addSubview:self.cardView];
        [_headerView addSubview:self.collectionView];
        [_headerView addSubview:self.btn_signIn];
    }
    return _headerView;
}

- (UIView *)cardView
{
    if (!_cardView) {
        _cardView = [[UIView alloc]initWithFrame:CGRectMake(10 * WIDTHRADIU, 10 * WIDTHRADIU, ScreenWidth - 20 * WIDTHRADIU, 145 * WIDTHRADIU)];
        _cardView.layer.cornerRadius = 15 * WIDTHRADIU;
        _cardView.layer.masksToBounds = YES;
        CAGradientLayer *layer = [CAGradientLayer new];
        //colors存放渐变的颜色的数组
        layer.colors=@[(__bridge id)[UIColor colorWithHex:0xf99804].CGColor,(__bridge id)[UIColor colorWithHex:0xfcc101].CGColor];
        /**
         * 起点和终点表示的坐标系位置，(0,0)表示左上角，(1,1)表示右下角
         */
        layer.startPoint = CGPointMake(0.4, 1);
        layer.endPoint = CGPointMake(0.6, 0);
        layer.frame = _cardView.bounds;
        [_cardView.layer addSublayer:layer];
        [_cardView addSubview:self.lb_coinsNum];
        [_cardView addSubview:self.lb_coinsNumTitle];
        [_cardView addSubview:self.btn_exchangeMoney];
        [_cardView addSubview:self.lb_allCoinsNumber];
        [_cardView addSubview:self.lb_mycoin];
        [_cardView addSubview:self.divideLine];
        [_cardView addSubview:self.lb_todayCoinsNumber];
        [_cardView addSubview:self.lb_todayCoin];
        
    }
    return _cardView;
}

- (UILabel *)lb_coinsNum
{
    if (!_lb_coinsNum) {
        _lb_coinsNum = [[UILabel alloc]init];
        _lb_coinsNum.text = @"10240";
        _lb_coinsNum.textColor = [UIColor whiteColor];
        _lb_coinsNum.font = [UIFont systemFontOfSize:35 * WIDTHRADIU];
        _lb_coinsNum.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_coinsNum;
}

- (UILabel *)lb_coinsNumTitle
{
    if (!_lb_coinsNumTitle) {
        _lb_coinsNumTitle = [[UILabel alloc]init];
        _lb_coinsNumTitle.text = @"总金币(个)";
        _lb_coinsNumTitle.textColor = [UIColor whiteColor];
        _lb_coinsNumTitle.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
        _lb_coinsNumTitle.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_coinsNumTitle;
}

- (ExchangeMoneyBtn *)btn_exchangeMoney
{
    if (!_btn_exchangeMoney) {
        _btn_exchangeMoney = [ExchangeMoneyBtn buttonWithType:UIButtonTypeCustom];
        [_btn_exchangeMoney setTitle:@"兑换现金" forState:UIControlStateNormal];
        [_btn_exchangeMoney setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _btn_exchangeMoney.titleLabel.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
        _btn_exchangeMoney.backgroundColor = [UIColor colorWithHex:0xfc9708];
        [_btn_exchangeMoney addTarget:self action:@selector(exchangeMoneyClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_exchangeMoney;
}

- (UILabel *)lb_allCoinsNumber
{
    if (!_lb_allCoinsNumber) {
        _lb_allCoinsNumber = [[UILabel alloc]init];
        _lb_allCoinsNumber.text = @"20240";
        _lb_allCoinsNumber.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _lb_allCoinsNumber.textColor = [UIColor colorWithHex:0Xfee2b8];
        _lb_allCoinsNumber.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_allCoinsNumber;
}

- (UILabel *)lb_mycoin
{
    if (!_lb_mycoin) {
        _lb_mycoin = [[UILabel alloc]init];
        _lb_mycoin.text = @"累计金币(个)";
        _lb_mycoin.textColor = [UIColor colorWithHex:0Xfee2b8];
        _lb_mycoin.font = [UIFont systemFontOfSize:13*WIDTHRADIU];
        _lb_mycoin.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_mycoin;
}

- (UIView *)divideLine
{
    if (!_divideLine) {
        _divideLine = [[UIView alloc]init];
        _divideLine.backgroundColor = [UIColor colorWithHex:0xfee2b8];
    }
    return _divideLine;
}

- (UILabel *)lb_todayCoinsNumber
{
    if (!_lb_todayCoinsNumber) {
        _lb_todayCoinsNumber = [[UILabel alloc]init];
        _lb_todayCoinsNumber.text = @"240";
        _lb_todayCoinsNumber.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _lb_todayCoinsNumber.textColor = [UIColor colorWithHex:0xfee2b8];
        _lb_todayCoinsNumber.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_todayCoinsNumber;
}

- (UILabel *)lb_todayCoin
{
    if (!_lb_todayCoin) {
        _lb_todayCoin = [[UILabel alloc]init];
        _lb_todayCoin.text = @"今日金币";
        _lb_todayCoin.textColor = [UIColor colorWithHex:0xfee2b8];
        _lb_todayCoin.font = [UIFont systemFontOfSize:13*WIDTHRADIU];
        _lb_todayCoin.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_todayCoin;
}


- (UICollectionView *)collectionView
{
    if (!_collectionView) {
        //创建一个layout布局类
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc]init];
        //设置布局方向为垂直流布局
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        //设置每个item的大小为100*100
        layout.itemSize = CGSizeMake(100, 60);

        _collectionView = [[UICollectionView alloc]initWithFrame:CGRectMake(20 * WIDTHRADIU, 170 * WIDTHRADIU, ScreenWidth - 40 * WIDTHRADIU, 49 * WIDTHRADIU) collectionViewLayout:layout];
        _collectionView.backgroundColor = [UIColor whiteColor];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        [_collectionView registerClass:[SignInCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
        [_collectionView registerClass:[LineCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"lineCell"];
    }
    return _collectionView;
}

- (UIButton *)btn_signIn
{
    if (!_btn_signIn) {
        _btn_signIn = [UIButton buttonWithType:UIButtonTypeCustom];
        _btn_signIn.frame = CGRectMake(10 * WIDTHRADIU, CGRectGetMaxY(self.collectionView.frame) + 15 * WIDTHRADIU, ScreenWidth - 20 * WIDTHRADIU, 45 * WIDTHRADIU);
        [_btn_signIn setTitle:@"今日已签到" forState:UIControlStateNormal];
        [_btn_signIn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
        _btn_signIn.titleLabel.font = [UIFont systemFontOfSize:17 * WIDTHRADIU];
        _btn_signIn.backgroundColor = [UIColor colorWithHex:0xffd28e];
        _btn_signIn.layer.cornerRadius = 22 * WIDTHRADIU;
    }
    return _btn_signIn;
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight - cl_kNavigationBarHeight)];
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.tableHeaderView = self.headerView;
        [_tableView registerClass:[CoinCenterTableViewCell class] forCellReuseIdentifier:@"cell"];
        _tableView.separatorStyle =  UITableViewCellSeparatorStyleNone;
        
        
    }
    return _tableView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
