//
//  FiveEightCityViewController.m
//  Open
//
//  Created by 看看智能 on 2018/3/7.
//  Copyright © 2018年 黄江涛 . All rights reserved.
//

#import "FiveEightCityViewController.h"

@interface FiveEightCityViewController ()<UITextFieldDelegate>
@property(nonatomic,strong)addressGatherModel *addressModel;
@end

@implementation FiveEightCityViewController
{
    __block  NSString *static_province_job;
    __block  NSString *static_city_job;
    __block  NSString *static_downTown_job;
    
    __block int genderID;
    
    
}
#pragma mark - 获取省份/市区/县
-(addressGatherModel *)addressModel
{
    if(!_addressModel){
        _addressModel =[[addressGatherModel alloc]initWithViewController:self];
    }
    return _addressModel;
    
}
- (void)viewDidLoad {
    [super viewDidLoad];
    

    
    SVProgressHUD.minimumDismissTimeInterval =1.0;
    //设置代理
    [self allDelegateAndAllZero:self.province];
    [self allDelegateAndAllZero:self.country];
    [self allDelegateAndAllZero:self.city];
    [self allDelegateAndAllZero:self.name];
    [self allDelegateAndAllZero:self.gedner];
    [self allDelegateAndAllZero:self.birth];
    //设置初始化
    genderID =1;
    
   
}
//可选的
-(void)allDelegateAndAllZero:(UITextField*)textField{
    textField.delegate =self;
    textField.textAlignment =NSTextAlignmentCenter;
    
}

-(void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    if ([UIScreen mainScreen].bounds.size.height ==480 ) {
        self.topCon.constant = 66;
        self.rightHeightCon.constant =1.73478;
    }
    
}


#pragma mark -所有不能手动输入的按钮
-(BOOL)textFieldShouldBeginEditing:(UITextField*)textField{
    
    
    
    if (textField !=  self.name) {
        [textField resignFirstResponder];
        [self provinceChoose:textField];

        return NO;
    }
        return YES;
    
    
}
- (IBAction)provinceChoose:(UITextField *)sender {
    //     [self show1:sender];
    if (sender == self.province) {
        [self.view endEditing:YES];
        [self provinceLogic];//选择省
        //        indexTag =1;
        
    }else if(sender == self.city)
    {[self.view endEditing:YES];
        [self downTownLogic];//选择市
        
    }else if (sender == self.country)
    {
        [self.view endEditing:YES];
        [self areaLogic];//选择区
    }else if (sender ==self.birth){
        [self.view endEditing:YES];
        [self timmer];//选择时间
        
    }else if(sender ==self.gedner){
         [self.view endEditing:YES];
        [self chooseGender];//选择性别
    }
    
}



-(void)chooseGender{
    __block NSArray *   array = @[@"男",@"女"];
    __weak typeof(self) wself = self;
    [self.addressModel onlySelect:array Handle:^(NSString *str1, NSString *str2, NSError *error) {
        //employeeFamilyRelation_ =  (int)[JobUtil chooseEmployeeFamilyRelation:[array copy] andSelectedString:str1];
        if (str1) {
            genderID  = (int)[array indexOfObject:str1]  +1;
        }
        wself.gedner.text = str1;
 
    }];
    
}

-(BOOL)textFieldShouldReturn:(UITextField *)textField
{
     [self.view endEditing:YES];
    return YES;
}

-(void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
}
#pragma mark - AllCityLogic
- (void)provinceLogic{
    
    [self.addressModel getProvinceHandle:^(NSString *str1, NSString *str2, NSError *error) {
        dispatch_async(dispatch_get_main_queue(), ^{
            // self.province.text = str1;
            self.province.text=str1;
            NSLog(@"%@",str2);
            static_province_job = str2;
            static_city_job =nil;
            static_downTown_job=nil;
            self.city.text = @"";
            self.country.text =@"";
        });
        
    }];
}
-(void)downTownLogic{
    if (!static_province_job ) {
        return;    }

    [self.addressModel getDownTown:static_province_job Handle:^(NSString *str1, NSString *str2, NSError *error) {
        dispatch_async(dispatch_get_main_queue(), ^{
            self.city.text = str1;
            static_city_job =str2;
            static_downTown_job =nil;
            self.country.text =@"";
        });
    }];
}
-(void)areaLogic{
    if (!static_city_job ) {
        return;
    }

    [self.addressModel getArea:static_city_job  Handle:^(NSString *str1, NSString *str2, NSError *error) {
        dispatch_async(dispatch_get_main_queue(), ^{
            self.country.text = str1;
            static_downTown_job =str2;
        });
    }];
    
}
-(void)timmer{
    
    __weak typeof(self) wself = self;
    [LYLDatePicker showDateDetermineChooseInView:self.view determineChoose:^(NSString *dateString) {
        dispatch_async(dispatch_get_main_queue(), ^{
            wself.birth.text = dateString;
        });
    }];
    
}
-(void)jumpToHTML5:(NSString*)url andJAnalytics:(NSString*)janalytics
{
    UIStoryboard *sb  =[UIStoryboard storyboardWithName:@"Main" bundle:nil];
    WebViewController *tc=[sb instantiateViewControllerWithIdentifier:@"webViewController"];
    tc.URL =[NSURL URLWithString:url];
    tc.hidesBottomBarWhenPushed =YES;
    tc.janalytics = janalytics;
    [self.navigationController pushViewController:tc animated:YES];
}
#pragma mark -  提交到最后一步
- (IBAction)nextButton:(id)sender {

    if(self.name.text.length ==0){
        [SVProgressHUD showErrorWithStatus:@"姓名为空"];
        return;
    }
    if(self.birth.text.length ==0){
        [SVProgressHUD showErrorWithStatus:@"生日为空"];
        return;
    }
    if(self.gedner.text.length ==0){
        [SVProgressHUD showErrorWithStatus:@"性别为空"];
        return;
    }
    if(self.province.text.length ==0){
        [SVProgressHUD showErrorWithStatus:@"省份为空"];
        return;
    }
    if(self.city.text.length ==0){
        [SVProgressHUD showErrorWithStatus:@"信息为空"];
        return;
    }
    if(self.country.text.length ==0){
        [SVProgressHUD showErrorWithStatus:@"信息为空"];
        return;
    }
    
    [weatherNetModel findJobInfoSaveloginId:0 tellIphone:0 Birth:self.birth.text name:self.name.text sex:genderID province:self.province.text county:self.country.text city:self.city.text address:self.address idcard:self.idcard handle:^(verifyAdressModel *model, NSError *error) {
        if (error) {
            return;
        }
        
        
        if (model.state == 200) {
            [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"fivesjob"];
            if (model.RESULT) {
                [self.navigationController popViewControllerAnimated:YES];
            }
          
        }else{
            [SVProgressHUD showErrorWithStatus:@"错误"];
        }
        

        
        
    }];
    
    
    
    
    
    
    
    
}







@end
