//
//  PaymentDetailViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/8/3.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "PaymentDetailViewController.h"
#import "PaymentDetailTableViewCell.h"

#import "Constants.h"
#import "UIColor+Hex.h"

@interface PaymentDetailViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)UIView *headerView;

@property (nonatomic, strong)UIView *topView;
@property (nonatomic, strong)UILabel *lb_paymentTitle;
@property (nonatomic, strong)UILabel *lb_payment;

@property (nonatomic, strong)UIView *bottomView;

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong)UIView *footerView;

@property (nonatomic, strong)UIView *footerBottomView;

@property (nonatomic, strong)UILabel *lb_remind;

@property (nonatomic, strong)UIView *footerTopView;

@property (nonatomic, strong)UILabel *lb_totalTitle;

@property (nonatomic, strong)UILabel *lb_company_totalNum;

@property (nonatomic, strong)UILabel *lb_personal_totalNum;

@property (nonatomic, strong)UILabel *lb_totalNum;

@end

@implementation PaymentDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.view.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
    
    [self.view addSubview:self.tableView];
    
    self.edgesForExtendedLayout=UIRectEdgeBottom;
    
}

- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self.lb_paymentTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.topView);
        make.top.offset(20 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_payment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.topView);
        make.top.equalTo(self.lb_paymentTitle.mas_bottom).offset(10 * WIDTHRADIU);
        make.height.offset(30 * WIDTHRADIU);
    }];
    
    CGFloat leftMargin = 17 * WIDTHRADIU;
    CGFloat middleDistance = 5 * WIDTHRADIU;
    CGFloat width = (ScreenWidth - 2 * leftMargin - 4 * middleDistance) / 5;
    [self.lb_totalTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.footerTopView);
        make.left.offset(leftMargin);
        make.width.offset(width);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_company_totalNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.footerTopView);
        make.left.equalTo(self.lb_totalTitle.mas_right).offset(2 * middleDistance + width);
        make.width.offset(width);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_personal_totalNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.footerTopView);
        make.left.equalTo(self.lb_company_totalNum.mas_right).offset(middleDistance);
        make.width.offset(width);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    [self.lb_totalNum mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.footerTopView);
        make.left.equalTo(self.lb_personal_totalNum.mas_right).offset(middleDistance);
        make.width.offset(width);
        make.height.offset(15 * WIDTHRADIU);
    }];
    
    
    [self.lb_remind mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(20 * WIDTHRADIU);
        make.right.offset(-20 * WIDTHRADIU);
        make.top.offset(15 * WIDTHRADIU);
    }];
    
    
}

#pragma mark - UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 5;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    PaymentDetailTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    cell.selectionStyle =  UITableViewCellSelectionStyleNone;
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 54 * WIDTHRADIU;
}


#pragma mark - getters and setters
- (UIView *)headerView
{
    if (!_headerView) {
        _headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 159 * WIDTHRADIU)];
        _headerView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
        [_headerView addSubview:self.topView];
        [_headerView addSubview:self.bottomView];
    }
    return _headerView;
}

- (UIView *)footerView
{
    if (!_footerView) {
        _footerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 250 * WIDTHRADIU)];
        _footerView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
        UIView *lineView = [[UIView alloc]initWithFrame:CGRectMake(10 * WIDTHRADIU, 0, ScreenWidth - 20 * WIDTHRADIU, 0.5)];
        lineView.backgroundColor = [UIColor colorWithHex:0xcccccc];
        [_footerView addSubview:lineView];
        [_footerView addSubview:self.footerTopView];
        [_footerView addSubview:self.footerBottomView];
    }
    return _footerView;
}

- (UIView *)footerBottomView
{
    if (!_footerBottomView) {
        _footerBottomView = [[UIView alloc]initWithFrame:CGRectMake(0, 56 * WIDTHRADIU, ScreenWidth, 100 * WIDTHRADIU)];
        _footerBottomView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
        _footerBottomView.layer.shadowColor = [UIColor colorWithHex:0x1886d3].CGColor;
        _footerBottomView.layer.shadowOffset = CGSizeMake(0, -1);
        _footerBottomView.layer.shadowOpacity = 0.2;
        _footerBottomView.layer.shadowRadius = 1 * WIDTHRADIU;
        
        [_footerBottomView addSubview:self.lb_remind];
    }
    return _footerBottomView;
}


- (UILabel *)lb_remind
{
    if (!_lb_remind) {
        _lb_remind = [[UILabel alloc]init];
        NSString *text1 = @"1、残保金因城市而异，本页展示仅供参考;\n";
        NSString *text2 = @"2、社保缴费额仅供参考，最终缴费额以社保局实际收取为准;\n";
        NSString *text3 = @"3、部分城市因价格调整滞后，可能存在社保预交费用，由于预收费不是最终准确费用，本计算结果暂不包含预收费。\n";
        
        NSMutableParagraphStyle * paragraphStyle = [[NSMutableParagraphStyle alloc] init];
        [paragraphStyle setLineSpacing:10 * WIDTHRADIU];
        
        NSMutableAttributedString *attributedString1 = [[NSMutableAttributedString alloc] initWithString:text1 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
        NSMutableAttributedString *attributedString2 = [[NSMutableAttributedString alloc] initWithString:text2 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
        NSMutableAttributedString *attributedString3 = [[NSMutableAttributedString alloc] initWithString:text3 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
       
        [attributedString1 appendAttributedString:attributedString2];
        [attributedString1 appendAttributedString:attributedString3];
        
        NSRange range = [[[text1 stringByAppendingString:text2] stringByAppendingString:text3]  rangeOfString:[[text1 stringByAppendingString:text2] stringByAppendingString:text3]];
        [attributedString1 addAttributes:@{NSForegroundColorAttributeName:[UIColor colorWithHex:0x999999],
                                           NSFontAttributeName:[UIFont systemFontOfSize:14 * WIDTHRADIU]} range:range];
        _lb_remind.attributedText = attributedString1;
        _lb_remind.numberOfLines = 0;
    }
    return _lb_remind;
}

- (UIView *)footerTopView
{
    if (!_footerTopView) {
        _footerTopView = [[UIView alloc]initWithFrame:CGRectMake(0, 0.5, ScreenWidth, 55 * WIDTHRADIU)];
        _footerTopView.backgroundColor = [UIColor whiteColor];
        
        [_footerTopView addSubview:self.lb_totalTitle];
        [_footerTopView addSubview:self.lb_company_totalNum];
        [_footerTopView addSubview:self.lb_personal_totalNum];
        [_footerTopView addSubview:self.lb_totalNum];
        
       
    }
    return _footerTopView;
}



- (UILabel *)lb_totalTitle
{
    if (!_lb_totalTitle) {
        _lb_totalTitle = [[UILabel alloc]init];
        _lb_totalTitle.text = @"合计";
        _lb_totalTitle.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_totalTitle.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _lb_totalTitle.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_totalTitle;
}

- (UILabel *)lb_company_totalNum
{
    if (!_lb_company_totalNum) {
        _lb_company_totalNum = [[UILabel alloc]init];
        _lb_company_totalNum.text = @"1416.80";
        _lb_company_totalNum.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_company_totalNum.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _lb_company_totalNum.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_company_totalNum;
}

- (UILabel *)lb_personal_totalNum
{
    if (!_lb_personal_totalNum) {
        _lb_personal_totalNum = [[UILabel alloc]init];
        _lb_personal_totalNum.text = @"517.34";
        _lb_personal_totalNum.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_personal_totalNum.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _lb_personal_totalNum.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_personal_totalNum;
}


- (UILabel *)lb_totalNum
{
    if (!_lb_totalNum) {
        _lb_totalNum = [[UILabel alloc]init];
        _lb_totalNum.text = @"1934.14";
        _lb_totalNum.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_totalNum.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        _lb_totalNum.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_totalNum;
}




- (UIView *)topView
{
    if (!_topView) {
        _topView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 100 * WIDTHRADIU)];
        _topView.backgroundColor = [UIColor colorWithHex:0x1886d3];
        [_topView addSubview:self.lb_paymentTitle];
        [_topView addSubview:self.lb_payment];
    }
    return _topView;
}

- (UILabel *)lb_paymentTitle
{
    if (!_lb_paymentTitle) {
        _lb_paymentTitle = [[UILabel alloc]init];
        _lb_paymentTitle.text = @"月缴费用(元)";
        _lb_paymentTitle.textColor = [UIColor whiteColor];
        _lb_paymentTitle.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
    }
    return _lb_paymentTitle;
}

- (UILabel *)lb_payment
{
    if (!_lb_payment) {
        _lb_payment = [[UILabel alloc]init];
        _lb_payment.text = @"1934.14";
        _lb_payment.textColor = [UIColor whiteColor];
        _lb_payment.font = [UIFont systemFontOfSize:30 * WIDTHRADIU];
    }
    return _lb_payment;
}

- (UIView *)bottomView
{
    if (!_bottomView) {
        _bottomView = [[UIView alloc]initWithFrame:CGRectMake(0, 100 * WIDTHRADIU, ScreenWidth, 59 * WIDTHRADIU)];
        _bottomView.backgroundColor = [UIColor whiteColor];
        CGFloat leftMargin = 17 * WIDTHRADIU;
        CGFloat middleDistance = 5 * WIDTHRADIU;
        CGFloat width = (ScreenWidth - 2 * leftMargin - 4 * middleDistance) / 5;
        NSArray *titleArray = @[@"险种",@"基数",@"企业",@"个人",@"合计"];
        for (int i = 0; i < titleArray.count; i++) {
            UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(leftMargin + i * (width + middleDistance), 15 * WIDTHRADIU, width, 15 * WIDTHRADIU)];
            label.text = titleArray[i];
            label.textColor = [UIColor colorWithHex:0x4d4d4d];
            label.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
            label.textAlignment = NSTextAlignmentCenter;
            [_bottomView addSubview:label];
        }
        
        UIView *lineView = [[UIView alloc]initWithFrame:CGRectMake(10 * WIDTHRADIU, 45 * WIDTHRADIU, ScreenWidth - 20 * WIDTHRADIU, 0.5)];
        lineView.backgroundColor = [UIColor colorWithHex:0xcccccc];
        [_bottomView addSubview:lineView];
        
    }
    return _bottomView;
}

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, ScreenHeight - cl_kNavigationBarHeight) style:UITableViewStylePlain];
        _tableView.backgroundColor = [UIColor colorWithHex:0xf5f5f5];
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.dataSource = self;
        _tableView.delegate = self;
        [_tableView registerClass:[PaymentDetailTableViewCell class] forCellReuseIdentifier:@"cell"];
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        _tableView.tableHeaderView = self.headerView;
        _tableView.tableFooterView = self.footerView;
    }
    return _tableView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
