//
//  WithDrawCollectionViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/7/8.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "WithDrawCollectionViewCell.h"
#import "UIColor+Hex.h"
#import "Constants.h"
#import <Masonry.h>

@interface WithDrawCollectionViewCell ()

@property (nonatomic, strong)UIImageView *imageView;

@property (nonatomic, strong)UILabel *lb_money;

@property (nonatomic, strong)UIImageView *iconImg;
@property (nonatomic, strong)UILabel *lb_wx;

@end

@implementation WithDrawCollectionViewCell
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self addSubview:self.imageView];
        [self addSubview:self.lb_money];
        [self addSubview:self.iconImg];
        [self addSubview:self.lb_wx];
        [self slayoutMyUI];
        
        self.layer.borderWidth = 1;
        self.layer.borderColor = [UIColor colorWithHex:0xcccccc].CGColor;
        self.layer.cornerRadius = 5;
        self.backgroundColor = [UIColor whiteColor];
        
        self.hiddenImg = NO;
    }
    
    return self;
}
- (void)slayoutMyUI
{
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.offset(0);
    }];
    
    [self.lb_money mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self);
    }];
    [self.iconImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.centerX.offset(-16 * WIDTHRADIU);
    }];
    [self.lb_wx mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self);
        make.centerX.offset(16 * WIDTHRADIU);
    }];
    
}

#pragma mark - setters and getters
- (UIImageView *)imageView
{
    if (!_imageView) {
        _imageView = [[UIImageView alloc]init];
        _imageView.image = [UIImage imageNamed:@"my_wallet_Withdrawaloffunds_Selected"];
    }
    return _imageView;
}

- (UILabel *)lb_money
{
    if (!_lb_money) {
        _lb_money = [[UILabel alloc]init];
        _lb_money.text = @"5元";
        _lb_money.textAlignment = NSTextAlignmentCenter;
        _lb_money.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_money.font = [UIFont systemFontOfSize:17* WIDTHRADIU];
    }
    return _lb_money;
}

- (UIImageView *)iconImg
{
    if (!_iconImg) {
        _iconImg = [[UIImageView alloc]init];
        _iconImg.image = [UIImage imageNamed:@"my_wallet_Withdrawaloffunds_theway_WeChat_normal"];
    }
    return _iconImg;
}

- (UILabel *)lb_wx
{
    if (!_lb_wx) {
        _lb_wx = [[UILabel alloc]init];
        _lb_wx.text = @"微信";
        _lb_wx.textAlignment = NSTextAlignmentCenter;
        _lb_wx.textColor = [UIColor colorWithHex:0x4d4d4d];
        _lb_wx.font = [UIFont systemFontOfSize:16* WIDTHRADIU];
    }
    return _lb_wx;
}

- (void)setHiddenImg:(BOOL)hiddenImg
{
    _hiddenImg = hiddenImg;
    if (_hiddenImg) {
        self.lb_money.hidden = YES;
        self.iconImg.hidden = NO;
        self.lb_wx.hidden = NO;
    }else{
        self.lb_money.hidden = NO;
        self.iconImg.hidden = YES;
        self.lb_wx.hidden = YES;
    }
}


@end
