//
//  WithDrawViewController.m
//  Open
//
//  Created by 雷俊博 on 2019/7/8.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "WithDrawViewController.h"
#import "Constants.h"
#import "UIColor+Hex.h"

#import "WithDrawCollectionViewCell.h"
#import "CoinsExchangeCollectionReusableView.h"
#import "WithDrawView.h"
#import "CoinsFooterView.h"
#import "WithDrawFooterView.h"

#define ColsSpace 10 * WIDTHRADIU
#define LeftSpace 20 * WIDTHRADIU
#define RowSpace 10 * WIDTHRADIU
@interface WithDrawViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic, strong)UICollectionView *collectionView;

@property (nonatomic, strong)WithDrawView *headerView;

@property (nonatomic, strong)UIButton *btn_Withdraw;

@end

@implementation WithDrawViewController
#pragma mark - life cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.collectionView];
    [self.view addSubview:self.btn_Withdraw];
}
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    NSLog(@"viewwill");
    self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    
    [self.transitionCoordinator animateAlongsideTransition:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
        self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
    }];
}
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.bottom.offset(-45 * WIDTHRADIU);
    }];
    [self.btn_Withdraw mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.offset(0);
        make.height.offset(45 * WIDTHRADIU);
    }];
}
#pragma mark - UICollectionViewDataSource
- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return 2;
}
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    if (section == 0) {
        return 1;
    }
    return 6;
}
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    WithDrawCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    if (indexPath.section == 0) {
        cell.hiddenImg = YES;
    }
    return cell;
}
//创建头视图
- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView
           viewForSupplementaryElementOfKind:(NSString *)kind
                                 atIndexPath:(NSIndexPath *)indexPath {
    if ([kind isEqualToString:UICollectionElementKindSectionHeader]) {
        CoinsExchangeCollectionReusableView *headView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader
                                                                                           withReuseIdentifier:@"headerCell"
                                                                                                  forIndexPath:indexPath];
        if (indexPath.section == 0) {
             headView.lb_title.text = @"提现方式";
        }else if (indexPath.section == 1){
             headView.lb_title.text = @"提现金额";
        }
       
        return headView;
    }
  
        if ([kind isEqualToString:UICollectionElementKindSectionFooter]) {
            if (indexPath.section == 0) {
                WithDrawFooterView *footerView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"WithDrawFooterView" forIndexPath:indexPath];
                return footerView;
            }
            if (indexPath.section == 1) {
                CoinsFooterView *footerView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"footerCell" forIndexPath:indexPath];
                footerView.lb_title.text = @"提现说明";
                
                NSString *text1 = @"1、由于微信支付要求实名制，非实名用户账号无法支持提现，\n请务必将提现的微信号进行实名认证！\n";
                NSString *text2 = @"2、每日提现总额受微信限制，若当日限额已满，请次日申请。\n";
                NSString *text3 = @"3、每日最多申请提现两次，提现申请将在两个小时内审核到账\n（如遇高峰期，可能延迟到账），请耐心等待。\n";
                
                NSMutableParagraphStyle * paragraphStyle = [[NSMutableParagraphStyle alloc] init];
                [paragraphStyle setLineSpacing:8];
                
                NSMutableAttributedString *attributedString1 = [[NSMutableAttributedString alloc] initWithString:text1 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
                NSMutableAttributedString *attributedString2 = [[NSMutableAttributedString alloc] initWithString:text2 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
                NSMutableAttributedString *attributedString3 = [[NSMutableAttributedString alloc] initWithString:text3 attributes:@{NSParagraphStyleAttributeName: paragraphStyle}];
                [attributedString1 appendAttributedString:attributedString2];
                [attributedString1 appendAttributedString:attributedString3];
                
                NSRange range = [[[text1 stringByAppendingString:text2] stringByAppendingString:text3] rangeOfString:[[text1 stringByAppendingString:text2] stringByAppendingString:text3]];
                [attributedString1 addAttributes:@{NSForegroundColorAttributeName:[UIColor colorWithHex:0x999999],
                                                   NSFontAttributeName:[UIFont systemFontOfSize:12 * WIDTHRADIU]} range:range];
                footerView.lb_content.attributedText = attributedString1;
                
                return footerView;
            }
           
        }
    
    
    return nil;
}

/**
 cell的大小
 */
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath{
    
    
    CGFloat width = (CGRectGetWidth(collectionView.bounds) - (3 - 1) * ColsSpace - LeftSpace * 2)  / 3;
    CGFloat height = 40 * WIDTHRADIU;
    CGSize size = CGSizeMake(width, height);
    return size;
}
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForFooterInSection:(NSInteger)section{
    
    if (section == 0) {
        return CGSizeMake(ScreenWidth, 45 * WIDTHRADIU);
    }else if (section == 1){
        return CGSizeMake(ScreenWidth, 240 * WIDTHRADIU);
    }
    return CGSizeZero;
}
/**
 每个分区的内边距（上左下右）
 */
- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout insetForSectionAtIndex:(NSInteger)section{
    return UIEdgeInsetsMake(0, LeftSpace, RowSpace + 5 * WIDTHRADIU, LeftSpace);
}
/**
 分区内cell之间的最小行间距
 */
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section{
    
    return RowSpace;
}
/**
 分区内cell之间的最小列间距
 */
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    return 0.0;
}
#pragma mark - setter and getter
- (UICollectionView *)collectionView
{
    if (!_collectionView) {
        UICollectionViewFlowLayout *layOut = [[UICollectionViewFlowLayout alloc]init];
        layOut.headerReferenceSize = CGSizeMake(CGRectGetWidth(self.view.bounds), 35 * WIDTHRADIU);
        layOut.minimumInteritemSpacing = 0;
        layOut.minimumLineSpacing = 0;
        _collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layOut];
        
        _collectionView.backgroundColor = [UIColor whiteColor];
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.showsVerticalScrollIndicator = NO;
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        [_collectionView registerClass:[WithDrawCollectionViewCell class] forCellWithReuseIdentifier:@"cell"];
         [_collectionView registerClass:[CoinsExchangeCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"headerCell"];
          [_collectionView registerClass:[CoinsFooterView class] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"footerCell"];
        [_collectionView registerClass:[WithDrawFooterView class] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"WithDrawFooterView"];
        [_collectionView addSubview:self.headerView];
        
        _collectionView.contentInset = UIEdgeInsetsMake(94* WIDTHRADIU, 0, 0,0);
    }
    return _collectionView;
}
- (WithDrawView *)headerView
{
    if (!_headerView) {
        _headerView = [[WithDrawView alloc]initWithFrame:CGRectMake(0, - 94 * WIDTHRADIU, ScreenWidth, 94 * WIDTHRADIU)];
    }
    return _headerView;
}
- (UIButton *)btn_Withdraw
{
    if (!_btn_Withdraw) {
        _btn_Withdraw =[UIButton buttonWithType:UIButtonTypeCustom];
        _btn_Withdraw.backgroundColor = [UIColor colorWithHex:0xed8b0b];
        _btn_Withdraw.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        [_btn_Withdraw setTitle:@"立即提现" forState:UIControlStateNormal];
    }
    return _btn_Withdraw;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
