//
//  CoinsExchangeVC.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsExchangeVC.h"
#import "Constants.h"
#import "UIColor+Hex.h"

#import "CoinsExchangeCell.h"
#import "CoinsExchangeCollectionReusableView.h"
#import "CoinsHeaderView.h"
#import "CoinsFooterView.h"


#define ColsSpace 10 * WIDTHRADIU
#define LeftSpace 20 * WIDTHRADIU
#define RowSpace 10 * WIDTHRADIU
@interface CoinsExchangeVC ()<UICollectionViewDelegate,UICollectionViewDataSource>
{
    NSDictionary *dic;
}

@property (nonatomic, strong)UICollectionView *collectionView;

@property (nonatomic, strong)CoinsHeaderView *headerView;

@property (nonatomic, strong)UIButton *btn_Exchange;

@property (nonatomic, strong)NSArray *dataArray;



@end

@implementation CoinsExchangeVC
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.collectionView];
    [self.view addSubview:self.btn_Exchange];
    NSIndexPath *index = [NSIndexPath indexPathForRow:0 inSection:0];
    [self.collectionView selectItemAtIndexPath:index animated:YES scrollPosition:UICollectionViewScrollPositionNone];
    dic = self.dataArray[0];
    [self.headerView refreshData];
}
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    
    [self.transitionCoordinator animateAlongsideTransition:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
        self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
    }];
}
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.bottom.offset(45 * WIDTHRADIU);
    }];
    [self.btn_Exchange mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.offset(0);
        make.height.offset(45 * WIDTHRADIU);
    }];
}
#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.dataArray.count;
}


- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    CoinsExchangeCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"cell" forIndexPath:indexPath];
    NSDictionary *dic = self.dataArray[indexPath.row];
   
    
    NSNumber *exchangeRate = [getPeopleID totalCoins] ?   [getPeopleID totalCoins][@"exchangeRate"]  : @10000;
    cell.lb_money.text = [NSString stringWithFormat:@"%@元",dic[@"moneyNum"]];
    NSNumber *exchangeRateNum = dic[@"coinsNum"];
    cell.lb_coins.text = [NSString stringWithFormat:@"%ld金币",[exchangeRate integerValue]*[exchangeRateNum integerValue]];
    
     cell.isSelected = NO;
    
    return cell;
}

//创建头视图
- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView
           viewForSupplementaryElementOfKind:(NSString *)kind
                                 atIndexPath:(NSIndexPath *)indexPath {
    if ([kind isEqualToString:UICollectionElementKindSectionHeader]) {
        CoinsExchangeCollectionReusableView *headView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader
                                                                                           withReuseIdentifier:@"headerCell"
                                                                                                  forIndexPath:indexPath];
        
        return headView;
    }
    
    if ([kind isEqualToString:UICollectionElementKindSectionFooter]) {
        CoinsFooterView *footerView = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"footerCell" forIndexPath:indexPath];
        return footerView;
    }
    
    return nil;
}

/**
 cell的大小
 */
- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath{
    
    
        CGFloat width = (CGRectGetWidth(collectionView.bounds) - (3 - 1) * ColsSpace - LeftSpace * 2)  / 3;
        CGFloat height = 60 * WIDTHRADIU;
     CGSize size = CGSizeMake(width, height);
        return size;
}
/**
 每个分区的内边距（上左下右）
 */
- (UIEdgeInsets)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout insetForSectionAtIndex:(NSInteger)section{
    return UIEdgeInsetsMake(0, LeftSpace, RowSpace, LeftSpace);
}
/**
 分区内cell之间的最小行间距
 */
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumLineSpacingForSectionAtIndex:(NSInteger)section{
   
    return RowSpace;
}
/**
 分区内cell之间的最小列间距
 */
- (CGFloat)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout minimumInteritemSpacingForSectionAtIndex:(NSInteger)section{
    return 0.0;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    CoinsExchangeCell *cell = (CoinsExchangeCell *)[collectionView cellForItemAtIndexPath:indexPath];
    
    cell.isSelected = ! cell.isSelected;
    
    dic = self.dataArray[indexPath.row];
    
}


#pragma mark event responses
- (void)btnClick:(UIButton *)sender
{
    
    NSNumber *exchangeRate = [getPeopleID totalCoins] ?   [getPeopleID totalCoins][@"exchangeRate"]  : @10000;
    NSNumber *exchangeRateNum = dic[@"coinsNum"];
    if ([getPeopleID totalCoins]) {
        NSDictionary *Mydic = [getPeopleID totalCoins];
        if ([Mydic[@"totalScore"] integerValue] < [exchangeRate integerValue]*[exchangeRateNum integerValue])  {
            [SVProgressHUD showInfoWithStatus:@"金币不足,请去赚金币"];
            return;
        }
    }
    [SVProgressHUD showInfoWithStatus:@"程序内测中,请先去看新闻赚金币!!!"];
}


#pragma mark - getters and setters
- (UICollectionView *)collectionView
{
    if (!_collectionView) {
        UICollectionViewFlowLayout *layOut = [[UICollectionViewFlowLayout alloc]init];
        layOut.headerReferenceSize = CGSizeMake(CGRectGetWidth(self.view.bounds), 35 * WIDTHRADIU);
        layOut.footerReferenceSize = CGSizeMake(CGRectGetWidth(self.view.bounds), 240 * WIDTHRADIU);
        layOut.minimumInteritemSpacing = 0;
        layOut.minimumLineSpacing = 0;
        _collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layOut];
       
        _collectionView.backgroundColor = [UIColor whiteColor];
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.showsVerticalScrollIndicator = NO;
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        [_collectionView registerClass:[CoinsExchangeCell class] forCellWithReuseIdentifier:@"cell"];
        [_collectionView registerClass:[CoinsExchangeCollectionReusableView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"headerCell"];
        [_collectionView registerClass:[CoinsFooterView class] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:@"footerCell"];
        
        [_collectionView addSubview:self.headerView];
        
        _collectionView.contentInset = UIEdgeInsetsMake(118* WIDTHRADIU, 0, 0,0);
    }
    return _collectionView;
}

- (CoinsHeaderView *)headerView
{
    if (!_headerView) {
        _headerView = [[CoinsHeaderView alloc]initWithFrame:CGRectMake(0, - 118 * WIDTHRADIU, ScreenWidth, 118 * WIDTHRADIU)];
    }
    return _headerView;
}

- (UIButton *)btn_Exchange
{
    if (!_btn_Exchange) {
        _btn_Exchange =[UIButton buttonWithType:UIButtonTypeCustom];
        _btn_Exchange.backgroundColor = [UIColor colorWithHex:0xed8b0b];
        _btn_Exchange.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        [_btn_Exchange setTitle:@"立即兑换" forState:UIControlStateNormal];
        [_btn_Exchange addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_Exchange;
}

- (NSArray *)dataArray
{
    if (!_dataArray) {
        _dataArray = @[
                       @{
                           @"moneyNum":[NSNumber numberWithInteger:1],
                           @"coinsNum":[NSNumber numberWithInteger:1]
                           },
        
                       @{
                           @"moneyNum":[NSNumber numberWithInteger:2],
                           @"coinsNum":[NSNumber numberWithInteger:2]
                           },
                       @{
                           @"moneyNum":[NSNumber numberWithInteger:5],
                           @"coinsNum":[NSNumber numberWithInteger:5]
                           },
                       @{
                           @"moneyNum":[NSNumber numberWithInteger:10],
                           @"coinsNum":[NSNumber numberWithInteger:10]
                           },
                       @{
                           @"moneyNum":[NSNumber numberWithInteger:15],
                           @"coinsNum":[NSNumber numberWithInteger:15]
                           },
                       @{
                           @"moneyNum":[NSNumber numberWithInteger:20],
                           @"coinsNum":[NSNumber numberWithInteger:20]
                           }
                       ];
    }
    return _dataArray;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
