//
//  CoinsDetailHeaderView.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsDetailHeaderView.h"
#import "Constants.h"
#import "UIColor+Hex.h"

@interface CoinsDetailHeaderView ()

@property (nonatomic, strong)UIView *backView;

@property (nonatomic, strong)UILabel *lb_coinsNum;

@property (nonatomic, strong)UILabel *lb_coinsNumTitle;

@property (nonatomic, strong) UILabel *lb_allCoinsNumber;
@property (nonatomic, strong) UILabel *lb_mycoin;
@property (nonatomic, strong) UIView *divideLine;

@property (nonatomic, strong) UILabel *lb_todayCoinsNumber;
@property (nonatomic, strong) UILabel *lb_todayCoin;



@end
@implementation CoinsDetailHeaderView
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = RGBCOLOR(244, 244, 244);
        [self addSubview:self.backView];
        [self addSubview:self.lb_coinsNum];
        [self addSubview:self.lb_coinsNumTitle];
        [self addSubview:self.lb_allCoinsNumber];
        [self addSubview:self.lb_mycoin];
        [self addSubview:self.divideLine];
        [self addSubview:self.lb_todayCoinsNumber];
        [self addSubview:self.lb_todayCoin];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.height.offset(151 * WIDTHRADIU);
    }];
    [self.lb_coinsNum mas_makeConstraints:^(MASConstraintMaker *make) {
       
        make.top.offset(25 * WIDTHRADIU);
        make.centerX.equalTo(self);
        make.height.offset(25 * WIDTHRADIU);
    }];
    [self.lb_coinsNumTitle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lb_coinsNum.mas_bottom).offset(10 * WIDTHRADIU);
        make.centerX.equalTo(self);
        make.height.offset(13 * WIDTHRADIU);
    }];
    [self.lb_allCoinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX).multipliedBy(0.5);
        make.top.equalTo(self.lb_coinsNumTitle.mas_bottom).offset(20 * WIDTHRADIU);
        make.height.offset(15 * WIDTHRADIU);
    }];
    [self.lb_mycoin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_allCoinsNumber);
        make.top.equalTo(self.lb_allCoinsNumber.mas_bottom).offset(10 * WIDTHRADIU);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    [self.divideLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.centerY.equalTo(self.lb_allCoinsNumber.mas_bottom).offset(4 * WIDTHRADIU);
        make.height.offset(35 * WIDTHRADIU);
        make.width.offset(0.5);
    }];
    [self.lb_todayCoinsNumber mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX).multipliedBy(1.5);
        make.centerY.equalTo(self.lb_allCoinsNumber);
        make.height.offset(15 * WIDTHRADIU);
    }];
    [self.lb_todayCoin mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.lb_todayCoinsNumber);
        make.centerY.equalTo(self.lb_mycoin);
        make.height.offset(13 * WIDTHRADIU);
    }];
    
    
}


#pragma mark - public methods
- (void)refreshData
{
//    _lb_allCoinsNumber.text = [NSString stringWithFormat:@"%@",[dic[@"totalScore"] stringValue]];
//    _lb_todayCoinsNumber.text = [NSString stringWithFormat:@"%@",[dic[@"todaySore"] stringValue]];
//    NSString *str = [NSString stringWithFormat:@"约%@元",dic[@"caculationMoney"] ];
    if (self.type == ListVCTypeMyWallet) {
        NSDictionary *dic = [getPeopleID totalCoins];
        self.lb_coinsNum.text = [getPeopleID totalCoins] ? [dic[@"totalScore"] stringValue] : @"0";
        self.lb_allCoinsNumber.text = [getPeopleID totalCoins] ? [dic[@"totalScore"] stringValue] : @"0";
        self.lb_todayCoinsNumber.text = [getPeopleID totalCoins] ? [dic[@"todaySore"] stringValue] : @"0" ;
    }else if (self.type == ListVCTypeCoinsDetail){
        NSDictionary *dic = [getPeopleID totalCoins];
        self.lb_coinsNum.text = [getPeopleID totalCoins] ? [dic[@"totalScore"] stringValue] : @"0";
        self.lb_allCoinsNumber.text = [getPeopleID totalCoins] ? [dic[@"totalScore"] stringValue] : @"0";
        self.lb_todayCoinsNumber.text = [getPeopleID totalCoins] ? [dic[@"todaySore"] stringValue] : @"0" ;
    }
   
    
}

#pragma mark - setters and getters
- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc]init];
        _backView.backgroundColor = [UIColor colorWithHex:0xed8b0b];
    }
    return _backView;
}
- (UILabel *)lb_coinsNum
{
    if (!_lb_coinsNum) {
        _lb_coinsNum = [[UILabel alloc]init];
        _lb_coinsNum.text = @"10240";
        _lb_coinsNum.textColor = [UIColor whiteColor];
        _lb_coinsNum.font = [UIFont systemFontOfSize:35 * WIDTHRADIU];
        _lb_coinsNum.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_coinsNum;
}

- (UILabel *)lb_coinsNumTitle
{
    if (!_lb_coinsNumTitle) {
        _lb_coinsNumTitle = [[UILabel alloc]init];
        _lb_coinsNumTitle.text = @"总金币(个)";
        _lb_coinsNumTitle.textColor = [UIColor whiteColor];
        _lb_coinsNumTitle.font = [UIFont systemFontOfSize:13 * WIDTHRADIU];
        _lb_coinsNumTitle.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_coinsNumTitle;
}
- (UILabel *)lb_allCoinsNumber
{
    if (!_lb_allCoinsNumber) {
        _lb_allCoinsNumber = [[UILabel alloc]init];
        _lb_allCoinsNumber.text = @"20240";
        _lb_allCoinsNumber.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _lb_allCoinsNumber.textColor = [UIColor colorWithHex:0Xfee2b8];
        _lb_allCoinsNumber.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_allCoinsNumber;
}

- (UILabel *)lb_mycoin
{
    if (!_lb_mycoin) {
        _lb_mycoin = [[UILabel alloc]init];
        _lb_mycoin.text = @"累计金币(个)";
        _lb_mycoin.textColor = [UIColor colorWithHex:0Xfee2b8];
        _lb_mycoin.font = [UIFont systemFontOfSize:13*WIDTHRADIU];
        _lb_mycoin.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_mycoin;
}

- (UIView *)divideLine
{
    if (!_divideLine) {
        _divideLine = [[UIView alloc]init];
        _divideLine.backgroundColor = [UIColor colorWithHex:0xfee2b8];
    }
    return _divideLine;
}

- (UILabel *)lb_todayCoinsNumber
{
    if (!_lb_todayCoinsNumber) {
        _lb_todayCoinsNumber = [[UILabel alloc]init];
        _lb_todayCoinsNumber.text = @"240";
        _lb_todayCoinsNumber.font = [UIFont systemFontOfSize:20 * WIDTHRADIU];
        _lb_todayCoinsNumber.textColor = [UIColor colorWithHex:0xfee2b8];
        _lb_todayCoinsNumber.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_todayCoinsNumber;
}

- (UILabel *)lb_todayCoin
{
    if (!_lb_todayCoin) {
        _lb_todayCoin = [[UILabel alloc]init];
        _lb_todayCoin.text = @"今日金币";
        _lb_todayCoin.textColor = [UIColor colorWithHex:0xfee2b8];
        _lb_todayCoin.font = [UIFont systemFontOfSize:13*WIDTHRADIU];
        _lb_todayCoin.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_todayCoin;
}

- (void)setType:(ListVCType)type
{
    _type = type;
    if (type == ListVCTypeMyWallet) {
        self.lb_coinsNum.text = @"1.50";
        self.lb_coinsNumTitle.text = @"总金额(元)";
        self.lb_allCoinsNumber.text = @"6.50";
        self.lb_mycoin.text = @"累计金额(元)";
        self.lb_todayCoinsNumber.text = @"0.0";
        self.lb_todayCoin.text = @"今日金额(元)";
    }
}
/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
