//
//  CoinsDetailListVC.m
//  Open
//
//  Created by 雷俊博 on 2019/7/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "CoinsDetailListVC.h"
#import "CoinsDetailListVC2.h"
#import "UIColor+Hex.h"
#import "Constants.h"

#import "CoinsListItemTableViewCell.h"
#import "CoinsDetailHeaderView.h"

#import "CoinsExchangeVC.h"
#import "WithDrawViewController.h"

#import "CoinDetailModel.h"

#import "CoinsDetailFooterView.h"

@interface CoinsDetailListVC ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)UITableView *tableView;
@property (nonatomic, strong)UIButton *btn_Exchange;
@property (nonatomic, strong)CoinsDetailHeaderView *headerView;

@property (nonatomic, strong)NSMutableArray *dataArray;

@property (nonatomic, strong)CoinsDetailFooterView *footerView;

@end

@implementation CoinsDetailListVC
#pragma mark - life cycle
- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.view.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:self.tableView];
    [self.view addSubview:self.btn_Exchange];
    self.tableView.tableFooterView = self.footerView;
    [self loadData];
    [self.headerView refreshData];
}
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    
    [self.transitionCoordinator animateAlongsideTransition:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
        self.navigationController.navigationBar.barTintColor = [UIColor colorWithHex:0xed8b0b];
    } completion:^(id<UIViewControllerTransitionCoordinatorContext>  _Nonnull context) {
    }];
}
- (void)viewWillLayoutSubviews
{
    [super viewWillLayoutSubviews];
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.offset(0);
        make.bottom.offset(-45 * WIDTHRADIU);
    }];
    [self.btn_Exchange mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.offset(0);
        make.height.offset(45 * WIDTHRADIU);
    }];
}


#pragma mark - call api
- (void)loadData{
    if ([getPeopleID PeopleID] && self.type == ListVCTypeCoinsDetail)
    {
        NSDictionary *params = @{
                                 @"uid":[NSNumber numberWithInteger:[getPeopleID PeopleID]],
                                 };
        NSString *url =[NSString stringWithFormat:@"%@score/findtotalscore",CoinsBaseUrl];
        [SVProgressHUD show];
        [BaseNetManager POST2:url parameters:params completionHandler:^(id responseObj, NSError *error) {
            [SVProgressHUD dismiss];
            if (responseObj) {
                NSString *code = [responseObj[@"code"] stringValue];
                if ([code isEqualToString:@"0"]) {
                    NSArray *array = responseObj[@"result"][@"detailInfo"];
                    self.dataArray = [CoinDetailModel mj_objectArrayWithKeyValuesArray:array];
                    [self.tableView reloadData];
                }else{
                    codeSelected *code = [codeSelected MustTakeReturn:[responseObj[@"code"] integerValue]];
                    [code returnCodeMethod];
                }
            }
        }];
    }
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CoinsListItemTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"cell"];
    
    cell.type = self.type;
    
    if (self.type == ListVCTypeCoinsDetail) {
        [cell refreshUIWithData:self.dataArray[indexPath.row]];
    }
    
    
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 62*WIDTHRADIU;
}


#pragma mark - event responses
- (void)btnClick:(UIButton *)sender
{
    CoinsDetailListVC2 *vc = [[CoinsDetailListVC2 alloc]init];
    vc.title = @"金币明细";
    [self.navigationController pushViewController:vc animated:YES];
    return;
    
    
    if (self.type == ListVCTypeCoinsDetail) {
        CoinsExchangeVC *vc = [[CoinsExchangeVC alloc]init];
        vc.title = @"金币兑换";
        
        [self.navigationController pushViewController:vc animated:YES];
    }else if (self.type == ListVCTypeMyWallet){
                WithDrawViewController *vc =[[WithDrawViewController alloc]init];
                vc.title = @"提现";
              [self.navigationController pushViewController:vc animated:YES];
    }
   
}

#pragma mark getters and setters
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        [_tableView registerClass:[CoinsListItemTableViewCell class] forCellReuseIdentifier:@"cell"];
        
        _tableView.tableHeaderView = self.headerView;
    }
    return _tableView;
}
- (UIButton *)btn_Exchange
{
    if (!_btn_Exchange) {
        _btn_Exchange =[UIButton buttonWithType:UIButtonTypeCustom];
        _btn_Exchange.backgroundColor = [UIColor colorWithHex:0xed8b0b];
        _btn_Exchange.titleLabel.font = [UIFont systemFontOfSize:15 * WIDTHRADIU];
        [_btn_Exchange setTitle:@"金币兑换" forState:UIControlStateNormal];
        [_btn_Exchange addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_Exchange;
}

- (CoinsDetailHeaderView *)headerView
{
    if (!_headerView) {
        _headerView = [[CoinsDetailHeaderView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 161 * WIDTHRADIU)];
    }
    return _headerView;
}

- (CoinsDetailFooterView *)footerView
{
    if (!_footerView) {
        _footerView = [[CoinsDetailFooterView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 42 * WIDTHRADIU)];
    }
    return _footerView;
}

- (void)setType:(ListVCType)type
{
    _type = type;
    if (type == ListVCTypeMyWallet) {
        self.headerView.type = type;
        [self.btn_Exchange setTitle:@"提现" forState:UIControlStateNormal];
    }
}

- (NSMutableArray *)dataArray
{
    if (!_dataArray) {
        _dataArray = [[NSMutableArray alloc]init];
    }
    return _dataArray;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
