//
//  SignInCollectionViewCell.m
//  Open
//
//  Created by 雷俊博 on 2019/8/6.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "SignInCollectionViewCell.h"

#import "UIColor+Hex.h"
#import "Constants.h"

@interface SignInCollectionViewCell ()

@property (nonatomic, strong)UIImageView *img_back;

@property (nonatomic, strong)UILabel *lb_num;

@property (nonatomic, strong)UILabel *lb_date;

@property (nonatomic, assign)ListCoinsPackageType type;

@end

@implementation SignInCollectionViewCell
#pragma mark - life cycle
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        [self addSubview:self.img_back];
        [self addSubview:self.lb_num];
        [self addSubview:self.lb_date];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    [self.img_back mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.offset(0);
        make.centerX.equalTo(self);
        make.width.height.offset(33 * WIDTHRADIU);
    }];
    
    [self.lb_num mas_makeConstraints:^(MASConstraintMaker *make) {
        make.center.equalTo(self.img_back);
    }];
    
    [self.lb_date mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.img_back.mas_bottom).offset(5 * WIDTHRADIU);
        make.centerX.equalTo(self.img_back);
        make.height.offset(11 * WIDTHRADIU);
    }];
    
}

#pragma mark - public methods
- (void)refreshUIWithData:(NSDictionary *)dic
{
    NSString *type = dic[@"type"];
    if ([type isEqualToString:@"num"]) {
        self.lb_num.text = dic[@"num"];
        self.img_back.image = [UIImage imageNamed:@"my_gold_Checkin_bg_normal"];
        self.type = ListCoinsPackageTypeNumber;
    }else if ([type isEqualToString:@"redPacket"]){
        self.type = ListCoinsPackageTypeRedPacket;
        
    }else if ([type isEqualToString:@"giftBag"]){
         self.type = ListCoinsPackageTypeGiftBag;
        self.img_back.image = [UIImage imageNamed:@"my_gold_Checkin_Friday_normal"];
    }else if ([type isEqualToString:@"treasureBox"]){
        self.type = ListCoinsPackageTypeTreasureBox;
        self.img_back.image = [UIImage imageNamed:@"my_gold_Checkin_Sunday_normal"];
    }
    
    self.lb_date.text = dic[@"title"];
}

#pragma mark - getters and setters

- (void)setType:(ListCoinsPackageType)type
{
    if ((type == ListCoinsPackageTypeRedPacket) || (type == ListCoinsPackageTypeGiftBag) || (type == ListCoinsPackageTypeTreasureBox)) {
        self.lb_num.hidden = YES;
    }else{
         self.lb_num.hidden = NO;
    }
}
- (UIImageView *)img_back
{
    if (!_img_back) {
        _img_back = [[UIImageView alloc]init];
        _img_back.image = [UIImage imageNamed:@""];
    }
    return _img_back;
}

- (UILabel *)lb_num
{
    if (!_lb_num) {
        _lb_num = [[UILabel alloc]init];
        _lb_num.text = @"20";
        _lb_num.textColor = [UIColor whiteColor];
        _lb_num.font = [UIFont systemFontOfSize:12 * WIDTHRADIU];
    }
    return _lb_num;
}

- (UILabel *)lb_date
{
    if (!_lb_date) {
        _lb_date = [[UILabel alloc]init];
        _lb_date.text = @"周一";
        _lb_date.textColor = [UIColor colorWithHex:0x808080];
        _lb_date.font = [UIFont systemFontOfSize:11 * WIDTHRADIU];
    }
    return _lb_date;
}

@end
