//
//  EnsurePaybackFrontView.m
//  Open
//
//  Created by 雷俊博 on 2019/8/7.
//  Copyright © 2019 黄江涛 . All rights reserved.
//

#import "EnsurePaybackFrontView.h"
#import "Constants.h"
#import "UIColor+Hex.h"
#import "DashLineView.h"

@interface EnsurePaybackFrontView ()

/** 遮罩 */
@property (nonatomic, strong) CAShapeLayer *maskLayer;
/** 路径 */
@property (nonatomic, strong) UIBezierPath *borderPath;

@property (nonatomic, strong)DashLineView *dottedLine;

@property (nonatomic, strong)UILabel *lb_cardName;

@property (nonatomic, strong)UILabel *lb_message;

@end

@implementation EnsurePaybackFrontView
{
    //虚线距view顶部的距离
    CGFloat _frontHeight;
    //中间两个小半圆的半径
    CGFloat _radii;
    //顶部view的圆角半径
    CGFloat _leftRadius;
    CGFloat _rightRadius;
}
#pragma mark - life cycle
- (instancetype)init
{
    self = [super init];
    if (self) {
        CAGradientLayer *layer = [CAGradientLayer new];
        //colors存放渐变的颜色的数组
        layer.colors=@[(__bridge id)[UIColor colorWithHex:0xf7aa72].CGColor,(__bridge id)[UIColor colorWithHex:0xfecb8a].CGColor];
        /**
         * 起点和终点表示的坐标系位置，(0,0)表示左上角，(1,1)表示右下角
         */
        layer.startPoint = CGPointMake(0, 1);
        layer.endPoint = CGPointMake(0.7, 0);
        layer.frame = CGRectMake(0, 0, 194 * WIDTHRADIU, 80 * WIDTHRADIU);
        [self.layer addSublayer:layer];
        // 初始化遮罩
        self.maskLayer = [CAShapeLayer layer];
        // 设置遮罩
        [self.layer setMask:self.maskLayer];
        // 初始化路径
        self.borderPath = [UIBezierPath bezierPath];
        
        _frontHeight = 64.f;
        _radii = 6.f * WIDTHRADIU;
        _leftRadius = 5.f * WIDTHRADIU;
        _rightRadius = 10.f * WIDTHRADIU;
        
       // self.backgroundColor = [UIColor redColor];
        
        [self addSubview:self.dottedLine];
        [self addSubview:self.lb_cardName];
        [self addSubview:self.lb_message];
        [self setupUI];
    }
    return self;
}

- (void)setupUI
{
    
   
    [self.dottedLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self).multipliedBy(0.48);
        make.centerY.equalTo(self);
        make.top.offset(self->_radii);
        make.bottom.offset(- self->_radii);
        make.width.offset(0.5);
    }];
    
    [self.lb_cardName mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.dottedLine).multipliedBy(0.5);
        make.centerY.equalTo(self);
        make.width.offset(17 * WIDTHRADIU);
    }];
    
    [self.lb_message mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.dottedLine.mas_right).offset(10 * WIDTHRADIU);
        make.centerY.equalTo(self);
    }];
}


#pragma mark - getters and setters
- (DashLineView *)dottedLine
{
    if (!_dottedLine) {
        _dottedLine = [[DashLineView alloc] initWithFrame:CGRectZero withLineLength:5 withLineSpacing:3 withLineColor:[UIColor whiteColor]];
        _dottedLine.backgroundColor = [UIColor colorWithHex:0xf7aa72];
       
    }
    return _dottedLine;
}

- (UILabel *)lb_cardName
{
    if (!_lb_cardName) {
        _lb_cardName = [[UILabel alloc]init];
        _lb_cardName.text = @"补\n签\n卡";
        _lb_cardName.textColor = [UIColor colorWithHex:0xfdf4e8];
        _lb_cardName.font = [UIFont boldSystemFontOfSize:17 * WIDTHRADIU];
        _lb_cardName.numberOfLines = 0;
        _lb_cardName.textAlignment = NSTextAlignmentCenter;
    }
    return _lb_cardName;
}

- (UILabel *)lb_message
{
    if (!_lb_message) {
        _lb_message = [[UILabel alloc]init];
       // _lb_message.text = @"仅用于签到补签\n兑换后不支持退换\n每张补签卡有效期7天";
        _lb_message.textColor = [UIColor colorWithHex:0xfde4b4];
        _lb_message.font = [UIFont systemFontOfSize:11 * WIDTHRADIU];
        _lb_message.numberOfLines = 0;
        _lb_message.textAlignment = NSTextAlignmentLeft;
        
        NSString *str = @"仅用于签到补签\n兑换后不支持退换\n每张补签卡有效期7天";
        
        NSMutableAttributedString *attributedStr = [[NSMutableAttributedString alloc] initWithString:str];
        NSMutableParagraphStyle *paragraphStyle = [[NSMutableParagraphStyle alloc] init];
        paragraphStyle.lineSpacing = 8.0; // 设置行间距
        paragraphStyle.alignment = NSTextAlignmentJustified; //设置两端对齐显示
        [attributedStr addAttribute:NSParagraphStyleAttributeName value:paragraphStyle range:NSMakeRange(0, attributedStr.length)];
        _lb_message.attributedText = attributedStr;
    }
    return _lb_message;
}




- (void)layoutSubviews {
    [super layoutSubviews];
    
    
    // Drawing code
    CGFloat viewWidth = self.bounds.size.width;
    CGFloat viewHieght = self.bounds.size.height;
    
    //卡片左边部分宽度比例
    CGFloat scale = 0.24;
    CGFloat leftCardWidth = viewWidth * scale;
    // 遮罩层frame
    self.maskLayer.frame = self.bounds;
    
    // 设置path起点
    [self.borderPath moveToPoint:CGPointMake(_leftRadius, 0)];
    
    [self.borderPath addLineToPoint:CGPointMake(leftCardWidth  - _radii, 0)];
    
    [self.borderPath addArcWithCenter:CGPointMake(leftCardWidth, 0) radius:_radii startAngle:M_PI endAngle:2 * M_PI clockwise:NO];
    [self.borderPath addLineToPoint:CGPointMake(viewWidth - _rightRadius, 0)];
     [self.borderPath addArcWithCenter:CGPointMake(viewWidth - _rightRadius, _rightRadius) radius:_rightRadius startAngle:3/2*M_PI endAngle:0 clockwise:YES];
    
     [self.borderPath addLineToPoint:CGPointMake(viewWidth, viewHieght - _rightRadius)];
     [self.borderPath addArcWithCenter:CGPointMake(viewWidth - _rightRadius, viewHieght - _rightRadius) radius:_rightRadius startAngle:0 endAngle:M_PI/2 clockwise:YES];
     [self.borderPath addLineToPoint:CGPointMake(leftCardWidth + _radii, viewHieght)];
    [self.borderPath addArcWithCenter:CGPointMake(leftCardWidth, viewHieght) radius:_radii startAngle:0 endAngle:M_PI clockwise:NO];
     [self.borderPath addLineToPoint:CGPointMake(_leftRadius, viewHieght)];
     [self.borderPath addArcWithCenter:CGPointMake(_leftRadius, viewHieght - _leftRadius) radius:_leftRadius startAngle:M_PI/2 endAngle:M_PI clockwise:YES];
    [self.borderPath addLineToPoint:CGPointMake(0, _leftRadius)];
    [self.borderPath addArcWithCenter:CGPointMake(_leftRadius, _leftRadius) radius:_leftRadius startAngle:M_PI endAngle:M_PI * 3/2 clockwise:YES];
    
   
    // 将这个path赋值给maskLayer的path
    self.maskLayer.path = self.borderPath.CGPath;
}

- (void)drawRect:(CGRect)rect
{
    
}


@end
